'MAY 2013
'picaxe Programming Editor 5.5.6
'this program is used with a 20M2 @32MHz 
'and the Globalsat EM-406A GPS module and DS1307 / DS3231 RTC (or equiv)
'the program allows for the synchronisation of an attached i2c RTC time & date to a GPS reference

'c.7 = switch push button to select preferred local time display (UTC,LOCAL or LOCAL DST)
'c.6 = serial data input from EM406A GPS receiver @ default 4800 baud
'c.5 = switch push button to initiate RTC sync with GPS

'array $B0 to $BB contains ascii GPS UTC time and date
'array $C0 to $CB contains ascii RTC time and date
'array $E0 to $EB contains ascii GPS local time and date

'general registers b16,b17,b26,b27 used throughout

#picaxe 20M2
setfreq m32				'set freq to 32MHz

pullup %1111111100000000	'pullup resistors ON all portc pins, OFF on all portb pins

symbol LCDaddress	=$4E       	'i2c Address of LCD (A0, A1, A2 pulled high on PCF8574)
symbol RTCaddress	=$D0		'i2c address of RTC

symbol UTCzone	="E"		'E=local time +ve UTC offset, W=local time -ve UTC offset
symbol UTCoffset  = 10		'nominal local time zone UTC offset (eg. Sydney=10) (must be +ve)
symbol toff_count =$60		'memory address containing value of time offset counter (0,1 or 2)
symbol toffset	=$61		'memory location containing preferred time offset value (0,x or x+1)
symbol dayoffset  =$62		'memory location containing day offset value (0 FALSE or 1 TRUE)
symbol leapyear   =$63		'memory location containing leap year value (0 FALSE or 1 TRUE)
symbol decday	=$64		'memory location containing decimal second value
symbol decmth	=$65		'memory location containing decimal minute value
symbol decyr	=$66		'memory location containing decimal hour value

'-------------------------------------------------------------------------------------------------------
'these settings are for the GY-LCD-V1 LCD i2c daughterboard
'with settable solder brdiges address A0,A1,A2 tied high
symbol  DB4       = bit0      ' LCD Data Line 4
symbol  DB5       = bit1      ' LCD Data Line 5
symbol  DB6       = bit2      ' LCD Data Line 6
symbol  DB7       = bit3      ' LCD Data Line 7
symbol  RS        = bit6      ' 0 = Command   1 = Data
symbol  RD        = bit5      ' 0 = Write     1 = Read
symbol  E         = bit4      ' 0 = Idle      1 = Active
symbol  BL 	 	= bit7	' BACK LIGHT bit assignment
symbol  BLcntrl   = 0		' BACK LIGHT CONTROL

#rem
'--------------------------------------------------------
'these settings are for the LCM1602 LCD i2c daughterboard
'with a fixed address A0,A1,A2 permanently tied high
Symbol  DB4       = bit4      ' LCD Data Line 4
Symbol  DB5       = bit5      ' LCD Data Line 5
Symbol  DB6       = bit6      ' LCD Data Line 6
Symbol  DB7       = bit7      ' LCD Data Line 7
Symbol  RS        = bit0      ' 0 = Command   1 = Data
Symbol  RD        = bit1      ' 0 = Write     1 = Read
Symbol  E         = bit2      ' 0 = Idle      1 = Active
Symbol  BL 	 	= bit3	' BACK LIGHT bit assignment
Symbol  BLcntrl   = 1		' BACK LIGHT CONTROL
'--------------------------------------------------------
#endrem

symbol  RSCMD     = 0         ' Select Command register
symbol  RSDAT     = 1         ' Select Data register

symbol  fetch     = b25
symbol  char      = b26

symbol string_address	=b14
symbol comma_count	=b15

read 255,b16		'this restores toffset to last value before power down
poke toffset,b16		'transfer this value to ram location (toffset) to limit eeprom read write cycles

gosub initLCD		'initialise i2c 20x4 LCD display

'====================================================================================

start:

	gosub LOCAL_timeselect	'select local time preference (UTC, LOCAL or LOCAL DST) by toggling switch on pinc.7
	
	gosub readGPS
	
		b16=UTCzone
		if b16="E" then :gosub EASTcalc else :gosub WESTcalc :endif
		
	gosub syncRTC

	gosub readRTC

	gosub LCDdisplay
	
	
goto start

end	'END OF MAIN PROGRAM
'==================================================================================================================

LOCAL_timeselect:

'check and debounce pinc.7, return if not pressed

b16=0
BUTTON c.7,0,255,0,b16,1,jumphere1
return

jumphere1:		'arrive here if c.7 goes low after debounce

b16=UTCzone		'E or W
b17=UTCoffset	'local time zone offset from UTC
if b16 ="E" then :b26=UTCoffset+1 else :b26=UTCoffset-1 :endif	'local time zone daylight savings offset from UTC

peek toff_count,b16	'fetch offset counter b16

		if b16>=3 then let b16=0 endif 		'reset 1 of 3 counter (b16=0 or b16=1 or b16=2)
		
		if b16=0 then :poke toffset,b17 :write 255,b17 :endif 'local time @ powerup
		if b16=1 then :poke toffset,b26 :write 255,b26 :endif	'local daylight savings time @ 1st button press
		if b16=2 then :poke toffset,0   :write 255,0   :endif	'UTC time @ 2nd button press
inc b16			'increment button counter		
poke toff_count,b16 	'store button counter in ram toff_count	

return
'============================================================================================

syncRTC:

'check and debounce pinc.5, return if not pressed

b16=0
BUTTON c.5,0,255,0,b16,1,jumphere2
return

jumphere2:		'arrive here if c.5 goes low after debounce

gosub writeRTC	'program RTC with GPS LOCAL time & date

return
'=============================================================================================

readGPS:

'this subroutine reads in the GPRMC NMEA string and determines UTC time and date ascii chars
'and stores them in the display array

bptr=$70
'serial in 60 chars of the NMEA GPRMC string with UTC time and date and store in ram from address $70
'note that the _ at line end allows long lines to be carried over into the next line

serin c.6,N4800_32,("GPRMC") ,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc _
				     ,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc _
				     ,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc _
				     ,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc _
				     ,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc _
				     ,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc
				     
'UTCtime is stored after the first comma in ascii format hhmmss (no need to count commas to find UTCtime)
'this will always correspond to string_address locations $71 $72 $73 $74 $75 $76 ($70 will contain the first comma)
'convert hrs ascii to decimal and then add time offset value and then convert back to ascii
							

'move to display array memory ($Bx for GPS UTC dispaly and $Ex for GPS LOCAL display)
peek $71,b16	'H tens ascii
poke $B0,b16
poke $E0,"0"	'the final value is calculated in either EASTcalc or WESTcalc

peek $72,b16	'H ascii
poke $B1,b16
poke $E1,"0"	'the final value is calculated in either EASTcalc or WESTcalc

peek $73,b16	'M tens ascii
poke $B2,b16
poke $E2,b16

peek $74,b16	'M ascii
poke $B3,b16
poke $E3,b16

peek $75,b16	'S tens ascii
poke $B4,b16
poke $E4,b16

peek $76,b16	'S ascii
poke $B5,b16
poke $E5,b16

'--------------------------------------------------------------------------------------------------------
'UTCdate (ddmmyy) is stored after the 9th comma in the NMEA string following the marker phrase "GPRMC"
'the string_address location of the 9th comma will vary due to length variations in the data in other parts of the NMEA string
'to find UTCdate first locate the 9th comma. 

'start looking along string for commas to count
string_address=$70	'beginning address

loop1:
peek string_address,b16
if b16="," then :inc comma_count :endif 'check if char is a comma

if comma_count=9 then :goto loop2 :else :inc string_address :goto loop1 :endif 'count 9 commas to get to utcdate field

'the next 6 chars are the GPS UTC date in ascii (ddmmyy)
'poke ascii values into address $B6 to $BB
'convert ascii values to decimal and poke to memory. Use these values in the date adjustment calculations.
'if dayoffset=1 then increment date by 1 day
'finally transfer the adjusted date to display array

loop2:
comma_count=0 'reset comma counter

inc string_address
peek string_address,b16
poke $B6,b16		'day tens ascii
poke $E6,b16		'put same value in LCD display array
b17=b16-$30*10

inc string_address
peek string_address,b16
poke $B7,b16		'day units ascii
poke $E7,b16
b16=b16-$30
b17=b17+b16
poke decday,b17		'address containing decimal day of month

inc string_address 
peek string_address,b16
poke $B8,b16		'month tens ascii
poke $E8,b16
b17=b16-$30*10

inc string_address
peek string_address,b16
poke $B9,b16		'month units ascii
poke $E9,b16
b16=b16-$30
b17=b17+b16
poke decmth,b17		'address containing decimal month

inc string_address
peek string_address,b16
poke $BA,b16		'year tens ascii
poke $Ea,b16
b17=b16-$30*10

inc string_address
peek string_address,b16
poke $BB,b16		'year units ascii
poke $EB,b16
b16=b16-$30
b17=b17+b16
poke decyr,b17		'address containing decimal year
	
b16=b17//4		'leap year calculation ie. a leap year is divisible by 4 with no remainder
if b16=0 then :poke leapyear,1 else :poke leapyear,0 :endif	'set leapyear flag =1 if leap year
	
return
'=============================================================================================================

EASTcalc:

'this routine is used to adjust GPS LOCAL time and date if greater than UTC ie. positive offset to UTC

peek toffset,b26	'restore time offest value

'calculate H as a decimal
peek $71,b16	'H tens ascii
b17=b16-$30*10	'H tens decimal
peek $72,b16	'H units ascii
b16=b16-$30		'H units decimal
b17=b17+b16+b26	'H in decimal plus toffset

'adjust H if toffset pushes H beyond 23 into the next day
if b17>23 then :let b17=b17-24 :poke dayoffset,1 else :poke dayoffset,0 :endif 'determine dayoffset boolean value

'convert to ascii and move to GPS local time display array
b16=b17/10  +$30	'quotient
b26=b17//10 +$30	'remainder
poke $E0,b16	'H tens  ascii to LCD display array, $E2,3,4,5 always the same as $B2,3,4,5
poke $E1,b26	'H units ascii to LCD display array


'commence date adjustment calculations for positive local time offsets from UTC
peek dayoffset,b26
if b26=0 then return :endif	'return, no adjustment required (ie. local date = UTC date)

peek decday,b16	'fetch dom
if b16<28 then :b16=b16+1 :poke decday,b16 :goto labelA :endif 'if dom <28 then adding a day does not affect month or year

peek decmth,b17	'fetch month
peek leapyear,b26 'fetch leapyear flag

if b16=28 and b17=2 and b26=0 then :poke decday,1 :poke decmth,3 :goto labelA :endif  'test 28FEB non leap year
if b16=28 and b17=2 and b26=1 then :poke decday,29    :goto labelA :endif		  'test 28FEB leap year

if b16=29 and b17=2 then :poke decday,1  :poke decmth,3  :goto labelA :endif	'test 29FEB

if b16=30 and b17=9 then  :poke decday,1 :poke decmth,10 :goto labelA :endif	'test if current month only has 30 days
if b16=30 and b17=4 then  :poke decday,1 :poke decmth,5  :goto labelA :endif	'and current date is the 30th
if b16=30 and b17=6 then  :poke decday,1 :poke decmth,7  :goto labelA :endif	'set dom to the 1st and inc month
if b16=30 and b17=11 then :poke decday,1 :poke decmth,12 :goto labelA :endif	'poke adjusted values into memory
if b16=30 then :poke decday,31 :goto labelA :endif					'current month has 31 days so just inc dom

'only arrive here if day = 31
peek decyr,b26
if b17=12 then :poke decday,1 :poke decmth,1 :b26=b26+1 :poke decyr,b26 :goto labelA :endif	'test for 31st DEC and inc year if reqrd

poke decday,1 :b17=b17+1 :poke decmth,b17	'current day is the 31st so set dom to 1st and inc month


'date adjustments are complete so convert decimal values back to ascii, move to display array
labelA:
peek decday,b16			'day of month
bintoascii b16,b17,b26,b27	'convert to ascii
poke $E6,b26 : poke $E7,b27	'update display array day of month

peek decmth,b16			'month
bintoascii b16,b17,b26,b27	'convert to ascii
poke $E8,b26 : poke $E9,b27	'update display array month

peek decyr,b16			'year
bintoascii b16,b17,b26,b27	'convert to ascii
poke $EA,b26 : poke $EB,b27	'update display array day of month


return
'============================================================================================================

WESTcalc:

'this routine is used to adjust GPS LOCAL time and date if less than UTC ie. negative offser to UTC

peek toffset,b26	'restore time offest value

'calculate H as a decimal
peek $71,b16	'H tens ascii
b17=b16-$30*10	'H tens decimal
peek $72,b16	'H units ascii
b16=b16-$30		'H units decimal
b17=b17+b16		'H in decimal

'adjust H if toffset pushes H below 0 into the previous day
if b26>b17 then :b17=b17+24-b26 :poke dayoffset,1 else :b17=b17-b26 :poke dayoffset,0 :endif

'convert to ascii and move to GPS local time dispaly array
b16=b17/10  +$30	'quotient
b26=b17//10 +$30	'remainder
poke $E0,b16	'H tens ascii
poke $E1,b26	'H units ascii


'commence date adjustment calculations for negative local time offsets from UTC
peek dayoffset,b26
if b26=0 then return :endif	'return, no adjustment required (ie. local date = UTC date)

peek decday,b16	'fetch dom
if b16>1 then :b16=b16-1 :poke decday,b16 :goto labelB :endif 'if dom >1 then subtracting a day does not affect month or year

'only arrive here if dom=1
peek decmth,b17	'fetch month
peek decyr,b26	'fetch year

if b17=1 then :poke decday,31 :poke decmth,12 :b26=b26-1 :poke decyr,b26 :goto labelB :endif 'if 1JAN then regress to 31DEC in previous year

if b17=9 then  :poke decday,31 :poke decmth,8  :goto labelB :endif	'if SEP 1 then regress to AUG 31
if b17=4 then  :poke decday,31 :poke decmth,3  :goto labelB :endif	'if APR 1 then regress to MAR 31
if b17=6 then  :poke decday,31 :poke decmth,5  :goto labelB :endif	'if JUN 1 then regress to MAY 31
if b17=11 then :poke decday,31 :poke decmth,10 :goto labelB :endif	'if NOV 1 then regress to OCT 31

peek leapyear,b16 'fetch leapyear flag (1=leapyear, 0=not leapyear
if b17=3 and b16=1 then :poke decday,29 :poke decmth,2 :goto labelB :endif
if b17=3 and b16=0 then :poke decday,28 :poke decmth,2 :goto labelB :endif 

'only arrive here if 1st day of a 31 day month (exc JAN)
b17=b17-1 :poke decday,30 :poke decmth,b17	'decrement month, set dom=30, update $Dx registers

'date adjustments are complete so convert decimal values back to ascii, move to display array
labelB:
peek decday,b16			'day of month
bintoascii b16,b17,b26,b27	'convert to ascii
poke $E6,b26 : poke $E7,b27	'update display array day of month

peek decmth,b16			'month
bintoascii b16,b17,b26,b27	'convert to ascii
poke $E8,b26 : poke $E9,b27	'update display array month

peek decyr,b16			'year
bintoascii b16,b17,b26,b27	'convert to ascii
poke $EA,b26 : poke $EB,b27	'update display array day of month


return

'=============================================================================================================

readRTC:
'this routine reads the RTC and converts BCD digits to ascii and stores them in memory
	
HI2cSetup I2CMASTER, RTCaddress, I2CSLOW_32, I2CBYTE
'set RTC as active i2c device then read 6 bytes of data
hi2cin 0,(b18,b19,b20,b21,b21,b22,b23)
							'b18=sec,b19=min,b20=hrs,b21=dom,b22=mnth,b23=year
							'note b4 appears twice in the readi2c command line, 
							'first entry (dow) into b4 is then immediately overwritten 
							'by second entry (dom) since dow is not required
	
	'convert bcd time to ascii chars for display purposes
	bcdtoascii b18,b16,b17			
	poke $C4,b16 :poke $C5,b17	'$C4=sec tens, $C5=sec units
		
	bcdtoascii b19,b16,b17
	poke $C2,b16 :poke $C3,b17	'$C2=min tens, $C3=min units
		
	bcdtoascii b20,b16,b17
	poke $C0,b16 :poke $C1,b17	'$C0=hrs tens, $C1=hrs units
		
	bcdtoascii b21,b16,b17
	poke $C6,b16 :poke $C7,b17	'$C6=dom tens, $C7=dom units
	
	bcdtoascii b22,b16,b17
	poke $C8,b16 :poke $C9,b17	'$C8=mnth tens, $C9=mnth units
	
	bcdtoascii b23,b16,b17
	poke $CA,b16 :poke $CB,b17	'$CA=year tens, $CB=year units
	
return
'==============================================================================

writeRTC:

HI2cSetup I2CMASTER, RTCaddress, I2CSLOW_32, I2CBYTE
'set RTC as active i2c device then write 8 bytes of data

'first convert stored ascii values back to BCD (use GPS LOCAL values) 

peek $E0,b16	'ascii value of hrs tens
peek $E1,b17	'ascii value of hrs units
b16=b16-$30		'convert hrs tens to decimal value
b17=b17-$30		'convert hrs units to decimal value
b20=b16*16+b17	'calculate BCD value of hrs 

peek $E2,b16	'as above for mins
peek $E3,b17
b16=b16-$30
b17=b17-$30
b19=b16*16+b17

peek $E4,b16	'as above for secs
peek $E5,b17
b16=b16-$30
b17=b17-$30
b18=b16*16+b17

peek $E6,b16	'as above for day of month (dom)
peek $E7,b17
b16=b16-$30
b17=b17-$30
b21=b16*16+b17

peek $E8,b16	'as above for month
peek $E9,b17
b16=b16-$30
b17=b17-$30
b22=b16*16+b17

peek $EA,b16	'as above for year
peek $EB,b17
b16=b16-$30
b17=b17-$30
b23=b16*16+b17
	
'write to RTC
'(sec,min,hrs,dow,day,month,year,1Hz flash ($10), dow always set to $00=SUNDAY due to dow not available from GPS)
hi2cout 0, (b18, b19, b20, $00, b21, b22, b23, $10) 

	
return
'==============================================================================

LCDdisplay:

HI2cSetup I2CMASTER, LCDaddress, I2CSLOW_32, I2CBYTE

char = $80
gosub SendCmdByte		'set cursor to line 1 position 1

char = "U"			'display "UTC"
gosub SendDataByte
char = "T"
gosub SendDataByte
char = "C"
gosub SendDataByte

char = $87
gosub SendCmdByte		'set cursor to line 1 position 8

char = "L"			'display "LOC"
gosub SendDataByte
char = "O"
gosub SendDataByte
char = "C"
gosub SendDataByte

char = $8E
gosub SendCmdByte		'set cursor to line 1 position 15

char = "R"			'display "RTC"
gosub SendDataByte
char = "T"
gosub SendDataByte
char = "C"
gosub SendDataByte
'----------------------------------------------------------- end of LCD line 1

char = $C0
gosub SendCmdByte		'set cursor to line 2 position 1
for fetch = $B0 to $B5 	'fetch GPS UTC time stored in memory
peek fetch,char
gosub SendDataByte	'display GPS 6 chars ie. hhmmss
next fetch

char = $C7
gosub SendCmdByte		'set cursor to line 2 position 8
for fetch = $E0 to $E5 	'fetch GPS local time stored in memory
peek fetch,char
gosub SendDataByte	'display GPS 6 chars ie. hhmmss
next fetch

char = $CE
gosub SendCmdByte		'set cursor to line 2 position 15
for fetch = $C0 to $C5 	'fetch RTCtime stored in memory
peek fetch,char
gosub SendDataByte	'display RTC 6 chars ie. hhmmss
next fetch
'---------------------------------------------------------- end of LCD line2

char = $94
gosub SendCmdByte		'set cursor to line 3 position 1
for fetch = $B6 to $BB 	'fetch GPS UTC date stored in memory
peek fetch,char
gosub SendDataByte	'display GPS 6 chars ie. ddmmyy
next fetch

char = $9B
gosub SendCmdByte		'set cursor to line 3 position 8
for fetch = $E6 to $EB 	'fetch GPS local date stored in memory
peek fetch,char
gosub SendDataByte	'display GPS 6 chars ie. ddmmyy
next fetch

char = $A2
gosub SendCmdByte		'set cursor to line 3 position 15
for fetch = $C6 to $CB 	'fetch RTCdate stored in memory
peek fetch,char
gosub SendDataByte	'display RTC 6 chars ie. ddmmyy
next fetch
'----------------------------------------------------------- end of LCD line 3

return
'============================================================================

SendInitCmdByte:

      Pause 160				'pause 20mS (@32MHz = 20x8=160) as per HD44780 spec

SendCmdByte:

      RS  = RSCMD				'send to Command register
	RD = 0				'write to the display
       
SendDataByte:

      BL=BLcntrl				'set backlight bit					
      
      DB4 = char / %00010000		'send MSB out first
      DB5 = char / %00100000
      DB6 = char / %01000000
      DB7 = char / %10000000
      

      E   = 0 : HI2cOut( b0 )		'pulse E high
      E   = 1 : HI2cOut( b0 )
      E   = 0 : HI2cOut( b0 )
      
      pause 40				'pause 5msec (@32MHz = 5x8=40) as per HD44780 spec

      DB4 = char / %00000001		'send LSB out second
      DB5 = char / %00000010
      DB6 = char / %00000100
      DB7 = char / %00001000

      E   = 0 : HI2cOut( b0 )		'pulse E high
      E   = 1 : HI2cOut( b0 )
      E   = 0 : HI2cOut( b0 )
      
      pause 40				'pause 5msec (@ 32MHz = 5x8=40) as per HD44780 spec

      RS  = RSDAT				'send to Data register Next

return
'=============================================================================

initLCD:

      HI2cSetup I2CMASTER, LCDaddress, I2CSLOW_32, I2CBYTE
      
      ' Nibble commands - To initialise 4-bit mode
      eeprom 0,( $33 )    ; %0011---- %0011----   8-bit / 8-bit
      eeprom 1,( $32 )    ; %0011---- %0010----   8-bit / 4-bit

      ' Byte commands - To configure the LCD

      eeprom 2,( $28 )    ; %00101000 %001LNF00   Display Format
      eeprom 3,( $0C )    ; %00001100 %00001DCB   Display On
      eeprom 4,( $06 )    ; %00000110 %000001IS   Cursor Move

                          ; L : 0 = 4-bit Mode    1 = 8-bit Mode
                          ; N : 0 = 1 Line        1 = 2 Lines
                          ; F : 0 = 5x7 Pixels    1 = N/A
                          ; D : 0 = Display Off   1 = Display On
                          ; C : 0 = Cursor Off    1 = Cursor On
                          ; B : 0 = Cursor Steady 1 = Cursor Flash
                          ; I : 0 = Dec Cursor    1 = Inc Cursor
                          ; S : 0 = Cursor Move   1 = Display Shift

      eeprom 5,( $01 )    ; Clear Screen

      for fetch = 0 To 5
        read fetch,char
        gosub SendInitCmdByte
      next fetch
     
return
'=============================================================================